module net.BurtonRadons.spyl.expressionAttr;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionSymbol;
private import net.BurtonRadons.spyl.expressionUnary;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** Attribute access; "a . b". */
class AttrExpression : UnaryExpression
{
    char [] b; /**< Attribute to match. */
    
    /** Assign the parameters. */
    this (Mark mark, Expression a, char [] b)
    {
        super (mark, a);
        this.b = b;
    }
    
    override Value evaluate (Scope scope)
    {
        return a.evaluate (scope).getattr (b).expand ();
    }
    
    override char [] toString ()
    {
        return subString (a) ~ "." ~ b;
    }
    
    override int precedence ()
    {
        return Precedence.Postfix;
    }
}
